(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17868,        546]*)
(*NotebookOutlinePosition[     18566,        570]*)
(*  CellTagsIndexPosition[     18522,        566]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Trayectoria de un proyectil", "Title"],

Cell[TextData[{
  "Imagina que una monta\[NTilde]a de altura ",
  StyleBox["h",
    FontSlant->"Italic"],
  " (metros) est\[AAcute] situada en el origen del plano y sobre ella hay un \
ca\[NTilde]\[OAcute]n que dispara un proyectil con un \[AAcute]ngulo de \
elevaci\[OAcute]n ",
  "\[Theta] y con velocidad ",
  StyleBox["v",
    FontSlant->"Italic"],
  " (metros/segundo). Considerando solamente la fuerza de la gravedad y \
despreciando la resistencia del aire, la posici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x(t), y(t))\)\)]],
  " que ocupa el proyectil en un momento ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0\)]],
  " viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`x(t) = \ v\ \(cos(\ \[Theta])\) t, \ 
      y(t) = h + v\ sen\ \((\ \[Theta])\) t\  - \ \(1\/2\) g\ t\^2\)]],
  ". Donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es la aceleraci\[OAcute]n debida a la gravedad. ",
  "En lo que sigue consideraremos, por comodidad, que la acelaraci\[OAcute]n \
de la gravedad es de ",
  Cell[BoxData[
      \(TraditionalForm\`10\ m/s\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`g = 10\ m/s\^2\)]],
  ". Con ello ",
  Cell[BoxData[
      \(TraditionalForm\`y(t) = 
        h\  + \ v\ sen\ \((\ \[Theta])\) t\  - \ 5\ t\^2\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 1.",
    FontWeight->"Bold"],
  " Dados \[Theta], ",
  StyleBox["v",
    FontSlant->"Italic"],
  " y ",
  StyleBox["h",
    FontSlant->"Italic"],
  ", calcula usando comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ":\na) El tiempo que tarda el proyectil en caer al suelo. \nb) El alcance \
del tiro, es decir, la distancia horizontal (medida sobre el eje de abscisas) \
que recorre el proyectil. Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`x(t)\)]],
  " es la distancia horizontal recorrida por el proyectil en el tiempo ",
  StyleBox["t",
    FontSlant->"Italic"],
  ".\nc) La altura m\[AAcute]xima alcanzada. \nDefine las correspondientes \
funciones de \[Theta], ",
  StyleBox["v",
    FontSlant->"Italic"],
  ", ",
  StyleBox["h",
    FontSlant->"Italic"],
  " ",
  StyleBox[" ",
    FontSlant->"Italic"],
  "\"tiempo\", \"alcance\" y \"altura\"."
}], "Text"],

Cell[TextData[{
  StyleBox["Sugerencias.",
    FontWeight->"Bold"],
  " Lo primero que tienes que hacer es informar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de las funciones que representan la trayectoria del proyectil. Interesa \
considerar como variables, no s\[OAcute]lo el tiempo ",
  StyleBox["t",
    FontSlant->"Italic"],
  ", sino tambi\[EAcute]n las condiciones iniciales ",
  StyleBox["h, v, ",
    FontSlant->"Italic"],
  "\[Theta]. As\[IAcute] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"x", Cell[TextData[{
              "[",
              Cell[BoxData[
                  FormBox[
                    StyleBox[
                      RowBox[{
                        StyleBox["v",
                          FontSlant->"Italic"], "_"}]], TraditionalForm]]],
              ", \[Theta]_,",
              StyleBox[" t",
                FontSlant->"Italic"],
              "_]"
            }]]}], ":=", " ", \(v\ Cos[\[Theta]]\ t\)}], TraditionalForm]]],
  ". An\[AAcute]logamente defines ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"y", "[", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["v",
                    FontSlant->"Italic"], "_"}]], ",", "\[Theta]_", ",", 
              StyleBox[
                RowBox[{
                  StyleBox["h",
                    FontSlant->"Italic"], "_"}]], ",", 
              StyleBox[
                RowBox[{
                  StyleBox["t",
                    FontSlant->"Italic"], "_"}]]}], "]"}], 
          "=", \(h\  + \ v\ Sin[\[Theta]]\ t\  - 5  t\^2\)}], 
        TraditionalForm]]],
  ". La funci\[OAcute]n \"tiempo",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox["v_",
              FontSlant->"Italic"], ",", "\[Theta]_", ",", 
            StyleBox["h_",
              FontSlant->"Italic"]}], "]"}], TraditionalForm]]],
  "\" la obtendr\[AAcute]s resolviendo respecto a ",
  StyleBox["t",
    FontSlant->"Italic"],
  " la ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"y", "[", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["v",
                    FontSlant->"Italic"], "_"}]], ",", "\[Theta]_", ",", 
              StyleBox["h_",
                FontSlant->"Italic"], 
              StyleBox[",",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{
                  StyleBox["t",
                    FontSlant->"Italic"], "_"}]]}], "]"}], "=", "0"}], 
        TraditionalForm]]],
  ".Ya s\[EAcute] que eso es muy f\[AAcute]cil pero se trata de que le pidas \
a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que lo haga. Hay dos soluciones y t\[UAcute] debes elegir la soluci\
\[OAcute]n correcta.  Ahora ya es f\[AAcute]cil definir la funci\[OAcute]n \
\"alcance",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox[
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "_"}]], ",", "\[Theta]_", ",", 
            StyleBox[
              RowBox[{
                StyleBox["h",
                  FontSlant->"Italic"], "_"}]]}], "]"}], TraditionalForm]]],
  "\". Tambi\[EAcute]n te recuerdo que D",
  Cell[BoxData[
      \(TraditionalForm\`\([y[v, z, h, t], t]\)\)]],
  " proporciona la derivada respecto a ",
  StyleBox["t",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`y[v, z, h, t]\)]],
  ". Porque necesitar\[AAcute]s derivar para calcular la altura \
m\[AAcute]xima y definir la funci\[OAcute]n\"altura",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox["v_",
              FontSlant->"Italic"], ",", "\[Theta]_", ",", 
            StyleBox["h_",
              FontSlant->"Italic"]}], "]"}], TraditionalForm]]],
  "\". No es necesario que justifiques (es inmediato) que la altura \
m\[AAcute]xima se alcanza en el \[UAcute]nico cero de la derivada de ",
  Cell[BoxData[
      FormBox[
        FormBox[\(y[v, z, h, t]\),
          "TraditionalForm"], TraditionalForm]]],
  " respecto a ",
  StyleBox["t",
    FontSlant->"Italic"],
  ".\nYa est\[AAcute] bien de sugerencias. Acaba lo poco que queda de este \
ejercicio antes de pasar al siguiente."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 2.",
    FontWeight->"Bold"],
  " Representa gr\[AAcute]ficamente la trayectoria hasta el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = 10\)]],
  " de un proyectil disparado con una condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`v = 100\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Pi]/3\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`h = 50\)]],
  ". Haz que en la gr\[AAcute]fica aparezca un punto rojo indicando la posici\
\[OAcute]n del proyectil en el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = 10\)]],
  ".\n",
  StyleBox["Sugerencias.",
    FontWeight->"Bold"],
  "  Se trata de representar la curva cuyas ecuaciones param\[EAcute]tricas \
son ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", Cell[TextData[{
            "[",
            Cell[BoxData[
                \(TraditionalForm\`100\)]],
            ", \[Pi]/3,",
            StyleBox[" t",
              FontSlant->"Italic"],
            "]"
          }]]}], TraditionalForm]]],
  " e ",
  Cell[BoxData[
      FormBox[
        RowBox[{"y", "[", 
          RowBox[{"100", ",", \(\[Pi]/3\), ",", "50", ",", 
            StyleBox["t",
              FontSlant->"Italic"]}], "]"}], TraditionalForm]]],
  ". Te recuerdo que para dibujar curvas dadas por ecuaciones \
param\[EAcute]tricas se usa el comando \
\"ParametricPlot[{\[CurlyPhi](t),\[Phi](t)},{t,tmin,tmax},opciones]\" donde {\
\[CurlyPhi](t),\[Phi](t)} son funciones de t en el intervalo [tmin,tmax]. Las \
opciones de \"ParametricPlot\" son casi las mismas que las de \"Plot\" las \
cuales supongo que ya las conoces. Primero, pide a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que represente la trayectoria ",
  StyleBox["pero no la muestre en pantalla",
    FontSlant->"Italic"],
  " (para ello usa la opci\[OAcute]n \"DisplayFunction->Identity\") y as\
\[IAcute]gnale un nombre a este gr\[AAcute]fico (por ejemplo, graf1) para \
poderlo llamar m\[AAcute]s tarde. Tambi\[EAcute]n necesitar\[AAcute]s \
producir un objeto gr\[AAcute]fico: un punto rojo situado en el extremo final \
de la trayectoria. Usa para ello el comando que produce objetos \
gr\[AAcute]ficos cuya sintaxis general, como ya debes saber, es \
\"Graphics[directivas gr\[AAcute]ficas, primitivas gr\[AAcute]ficas,opciones]\
\". Necesitar\[AAcute]s s\[OAcute]lo dos directivas gr\[AAcute]ficas: Hue (o \
RGBColor) y PointSize, y una \[UAcute]nica primitiva gr\[AAcute]fica: \
Point[{x,y}]. No necesitas dar opciones. As\[IAcute]gnale tambi\[EAcute]n un \
nombre a este objeto gr\[AAcute]fico (por ejemplo, graf2).\nComo sabes, la \
salida del comando \"ParametricPlot\" y de \"Graphics\" son objetos gr\
\[AAcute]ficos que puedes mostrar con el comando \
\"Show[{graf1,graf2},opciones]\". Debes ahora dar la opci\[OAcute]n \
\"DisplayFunction->$DisplayFunction\". Si quieres ver la forma real de la \
trayectoria usa tambi\[EAcute]n la opci\[OAcute]n \"AspectRatio->1\". "
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 3.",
    FontWeight->"Bold"],
  " Aprovecha el trabajo hecho en los puntos anteriores para obtener una \
funci\[OAcute]n \"disparo[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "]\" que realice una animaci\[OAcute]n mostrando la trayectoria seguida y \
el movimiento de un proyectil (representado por un punto rojo) disparado con \
las condiciones iniciales ",
  StyleBox["v",
    FontSlant->"Italic"],
  ", \[Theta], ",
  StyleBox["h",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["Sugerencias.",
    FontWeight->"Bold"],
  " F\[IAcute]jate, la funci\[OAcute]n disparo[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "] debe tener como salida una animaci\[OAcute]n. Como ya sabes, para \
producir una animaci\[OAcute]n todo lo que se necesita es obtener las gr\
\[AAcute]ficas individuales que la forman. En nuestro caso, las \
gr\[AAcute]ficas individuales representar\[AAcute]n la trayectoria parcial \
hasta un instante T, adem\[AAcute]s deben depender de las condiciones \
iniciales ",
  StyleBox["v",
    FontSlant->"Italic"],
  ", \[Theta], ",
  StyleBox["h",
    FontSlant->"Italic"],
  ". En \"graf1\" sustituye 10 por T. Tambi\[EAcute]n debes sustituir los \
valores particulares 100, \[Pi]/3, 50 de las condiciones iniciales por ",
  StyleBox["v",
    FontSlant->"Italic"],
  ", \[Theta] y ",
  StyleBox["h",
    FontSlant->"Italic"],
  ". Al resultado puedes llamarle \"parabola",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox[
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "_"}]], ",", "\[Theta]_", ",", 
            StyleBox[
              RowBox[{
                StyleBox["h",
                  FontSlant->"Italic"], "_"}]], ",", "T_"}], "]"}], 
        TraditionalForm]]],
  "\". Como esas par\[AAcute]bolas van a formar una animaci\[OAcute]n \
conviene fijar el intervalo del eje de ordenadas dondese van a visualizar sus \
gr\[AAcute]ficas. Usa para ello la opci\[OAcute]n \
\"PlotRange->{{xmin,xmax},{ymin,ymax}}\". Parece razonable tomar xmin=0, \
ymin=0. Como xmax es l\[OAcute]gico tomar una distancia algo mayor que el \
alcance (que depende de las condiciones iniciales), por ejemplo, xmax = \
alcance[v,\[Theta],h] + 100. Ahora ya sabr\[AAcute]s c\[OAcute]mo definir \
ymax. \nAhora haces lo propio con \"graf2\" y al resultado le llamas \"bala",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox[
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "_"}]], ",", "\[Theta]_", ",", 
            StyleBox[
              RowBox[{
                StyleBox["h",
                  FontSlant->"Italic"], "_"}]], ",", "T_"}], "]"}], 
        TraditionalForm]]],
  "\". Ya puedes obtener las gr\[AAcute]ficas individuales modificando \
convenientemente el comando \"Show\" del punto anterior. Al resultado puedes \
llamarle \"trayectoria[",
  StyleBox["v",
    FontSlant->"Italic"],
  "_,\[Theta]_,",
  StyleBox["h",
    FontSlant->"Italic"],
  "_,T_]\". Ahora ya puedes obtener  la funci\[OAcute]n \"disparo[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "]\" con un \"Do[trayectoria",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox["v_",
              FontSlant->"Italic"], ",", "\[Theta]_", ",", 
            StyleBox["h_",
              FontSlant->"Italic"], ",", "T_"}], "]"}], TraditionalForm]]],
  ",{T,Tmin,Tmax,incT}]\" (debes definir Tmin=0, Tmax=tiempo[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "], incT=tiempo[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "]/10). Comprueba la funci\[OAcute]n obtenida con distintos valores de ",
  StyleBox["v,",
    FontSlant->"Italic"],
  " \[Theta] y ",
  StyleBox["h",
    FontSlant->"Italic"],
  " . Por ejemplo ",
  Cell[BoxData[
      \(TraditionalForm\`v = 100\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Theta] = \[Pi]/3\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`h = 200\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 4.",
    FontWeight->"Bold"],
  " Dados ",
  StyleBox["v",
    FontSlant->"Italic"],
  " y ",
  StyleBox["h",
    FontSlant->"Italic"],
  ", calcular el \[AAcute]ngulo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\_opt\)]],
  " para que el alcance del proyectil sea m\[AAcute]ximo."
}], "Text"],

Cell[TextData[{
  StyleBox["Sugerencias.",
    FontWeight->"Bold"],
  " Se trata de calcular el m\[AAcute]ximo absoluto de la funci\[OAcute]n \
alcance",
  "[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "]",
  " ",
  StyleBox["considerada como funci\[OAcute]n de",
    FontSlant->"Italic"],
  " \[Theta] ",
  StyleBox["solamente",
    FontSlant->"Italic"],
  " (se suponen unos valores dados de ",
  StyleBox["v",
    FontSlant->"Italic"],
  " y de ",
  StyleBox["h",
    FontSlant->"Italic"],
  "). Oberva que ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/
          2 \[LessEqual] \[Theta] \[LessEqual] \[Pi]/2\)]],
  " y que ",
  "alcance",
  "[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Pi]/2,",
  StyleBox["h",
    FontSlant->"Italic"],
  "]=",
  "alcance",
  "[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",-\[Pi]/2,",
  StyleBox["h",
    FontSlant->"Italic"],
  "]=0. Como ",
  "alcance",
  "[",
  StyleBox["v",
    FontSlant->"Italic"],
  ",\[Theta],",
  StyleBox["h",
    FontSlant->"Italic"],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[GreaterEqual]\)\(0\)\)\)]],
  ", deducimos que el m\[AAcute]ximo absoluto de dicha funci\[OAcute]n (cuya \
existencia garantiza el teorema de valores m\[AAcute]ximos de Weierstrass) se \
alcanza en un punto del intervalo ]-\[Pi]/2,\[Pi]/2[ y por tanto la derivada \
tiene que anularse en dicho punto. P\[IAcute]dele a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que haga los c\[AAcute]lculos. \[DownQuestion]Cu\[AAcute]l es el valor de \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\_opt\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`h = 0\)]],
  "?"
}], "Text"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 873}},
WindowSize->{1272, 835},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "DemoJPG.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 44, 0, 132, "Title"],
Cell[1752, 52, 1320, 37, 161, "Text"],
Cell[3075, 91, 934, 31, 277, "Text"],
Cell[4012, 124, 4396, 130, 264, "Text"],
Cell[8411, 256, 3007, 69, 449, "Text"],
Cell[11421, 327, 4362, 131, 421, "Text"],
Cell[15786, 460, 339, 13, 50, "Text"],
Cell[16128, 475, 1736, 69, 158, "Text"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

